%% Save AMPC results
% Create structures to save
simlog = simlog_ElectricVehicleThermalManagement;
chiller.efficiency.effCoeff = Efficiency_chiller;
%condenser.efficiency.effCoeff = Efficiency_condenser;
chiller.TwoP.h.in = h_chiller_2P_in;
chiller.TwoP.h.out =  h_chiller_2P_out;
chiller.TL.h.in = h_chiller_TL_in;
chiller.TL.h.out = h_chiller_TL_out;
compressor.fluid.h.in = h_comp_in;
compressor.fluid.h.out = h_comp_out;
condenser.TwoP.h.in = h_cond_2P_in;
condenser.TwoP.h.out = h_cond_2P_out;
battery.Q_joule = Q_joule;
battery.T = BatteryTemperature;
battery.i.tot = i_battery;
battery.i.BMS = i_BMS;
chiller.TwoP.mdot = mdot_chiller_2P_out;
chiller.TL.mdot.in = mdot_chiller_TL_in;
chiller.TL.mdot.out = mdot_chiller_TL_out;
chillerByPassValve.mdot.in = mdot_ChillerByPassValve_in;
chillerByPassValve.mdot.outB = mdot_ChillerByPassValve_outB;
chillerByPassValve.mdot.outC = mdot_ChillerByPassValve_outC;
compressor.fluid.mdot.in = mdot_comp_in;
compressor.fluid.mdot.out = mdot_comp_out;
condenser.TwoP.mdot.out = mdot_cond_2P_out;
condenser.TwoP.mdot.in = mdot_cond_in;
battery.coolant.SC3.mdot = mdot_coolant_battery_in;
battery.coolant.SC4.mdot = mdot_coolant_battery_out;
chiller.TwoP.p.in = p_chiller_2P_in;
chiller.TwoP.p.out = p_chiller_2P_out;
chiller.TL.p.in = p_chiller_TL_in;
chiller.TL.p.out = p_chiller_TL_out;
chillerByPassValve.p.in = p_ChillerByPassValve_in;
chillerByPassValve.p.outB = p_ChillerByPassValve_outB;
chillerByPassValve.p.outC = p_ChillerByPassValve_outC;
compressor.fluid.p.in = p_comp_in;
compressor.fluid.p.out = p_comp_out;
condenser.TwoP.p.in = p_cond_2P_in;
condenser.TwoP.p.out = p_cond_2P_out;
battery.coolant.SC3.p = p_coolant_battery_in;
battery.coolant.SC4.p = p_coolant_battery_out;
battery.coolant.SC3.Phi = Phi_battery_in;
battery.coolant.SC4.Phi = Phi_battery_out;
chiller.TwoP.Phi.in = Phi_chiller_2P_in;
chiller.TwoP.Phi.out = Phi_chiller_out;
chiller.TL.Phi.in = Phi_chiller_TL_in;
chiller.TL.Phi.out = Phi_chiller_TL_out;
chillerByPassValve.Phi.in = Phi_ChillerByPassValve_in;
chillerByPassValve.Phi.outB = Phi_ChillerByPassValve_outB;
chillerByPassValve.Phi.outC = Phi_ChillerByPassValve_outC;
compressor.fluid.Phi.in = Phi_comp_in;
compressor.fluid.Phi.out = Phi_comp_out;
condenser.TwoP.Phi.in = Phi_cond_in;
condenser.TwoP.Phi.out = Phi_cond_out;
chiller.TL.rho.in = rho_chiller_TL_in;
chiller.TL.rho.out = rho_chiller_TL_out;
chillerByPassValve.rho.in = rho_ChillerByPassValve_in;
chillerByPassValve.rho.outB = rho_ChillerByPassValve_outB;
chillerByPassValve.rho.outC = rho_ChillerByPassValve_outC;
battery.coolant.SC3.rho = rho_coolant_battery_in;
battery.coolant.SC4.rho = rho_coolant_battery_out;
chiller.TwoP.T.in = T_chiller_2P_in;
chiller.TwoP.T.out = T_chiller_2P_out;
chiller.TL.T.in = T_chiller_TL_in;
chiller.TL.T.out = T_chiller_TL_out;
chillerByPassValve.T.in = T_ChillerByPassValve_in;
chillerByPassValve.T.outB = T_ChillerByPassValve_outB;
chillerByPassValve.T.outC = T_ChillerByPassValve_outC;
compressor.fluid.T.in = T_comp_in;
compressor.fluid.T.out = T_comp_out;
condenser.TwoP.T.in = T_cond_2P_in;
condenser.TwoP.T.out = T_cond_2P_out;
battery.coolant.SC3.T = T_coolant_battery_in;
battery.coolant.SC4.T = T_coolant_battery_out;
chiller.TwoP.u.in = u_chiller_2P_in;
chiller.TwoP.u.out = u_chiller_2P_out;
chiller.TL.u.in = u_chiller_TL_in;
chiller.TL.u.out = u_chiller_TL_out;
chillerByPassValve.u.in = u_ChillerByPassValve_in;
chillerByPassValve.u.outB = u_ChillerByPassValve_outB;
chillerByPassValve.u.outC = u_ChillerByPassValve_outC;
compressor.fluid.u.in = u_comp_in;
compressor.fluid.u.out = u_comp_out;
condenser.TwoP.u.in = u_cond_2P_in;
condenser.TwoP.u.out = u_cond_2P_out;
battery.coolant.SC3.u = u_coolant_battery_in;
battery.coolant.SC4.u = u_coolant_battery_out;
chiller.TwoP.v.in = v_chiller_2P_in;
chiller.TwoP.v.out = v_chiller_2P_out;
compressor.fluid.v.in = v_comp_in;
compressor.fluid.v.out = v_comp_out;
condenser.TwoP.v.in = v_cond_2P_in;
condenser.TwoP.v.out = v_cond_2P_out;
compressor.fluid.vL.in = vL_comp_in;
compressor.fluid.vL.out = vL_comp_out;
compressor.fluid.vV.in = vV_comp_in;
compressor.fluid.vV.out = vV_comp_out;
chiller.TwoP.x.in = x_chiller_2P_in;
chiller.TwoP.x.out = x_chiller_2P_out;
compressor.fluid.x.in = x_comp_in;
compressor.fluid.x.out = x_comp_out;
condenser.TwoP.x.out = x_cond_2P_out;
condenser.TwoP.x.in = x_cond_2P_in;
battery.T = BatteryTemperature;
condenser.efficiency.h_infinite = h_infiniteCond;
chiller.efficiency.h_infinite = h_infiniteChiller;
EPowers.Compressor = EPower_Compressor;
EPowers.Fan = EPower_Fan;
EPowers.MotorPump = EPower_MotorPump;
EPowers.BatteryPump = EPower_BatteryPump;
battery.V = Voltage_battery;
ElectricEnergy.battery.BTM.tot = Energy_BTM;
ElectricEnergy.battery.tot = Energy_battery;
ElectricEnergy.battery.PowerTrain.values = Energy_battery.signals.values - Energy_BTM.signals.values;
ElectricEnergy.battery.PowerTrain.time = Energy_battery.time;
ElectricEnergy.battery.BTM.compressor = Energy_compressor;
ElectricEnergy.battery.BTM.fan = Energy_fan;

% Compute volumetric efficiency compressor
eta_Vnominal = 0.9;
gamma = 1.13;
p_in_nom = 0.3; %MPa
beta_nom = 4.6;
vr_nominal = ((beta_nom*p_in_nom)/(p_in_nom))^(1/gamma);
C = (1-eta_Vnominal)/(vr_nominal-1);
VolumetricEfficiency.time = compressor.fluid.v.out.time;
VolumetricEfficiency.values = zeros(length(compressor.fluid.v.out.time),1);
for t = 1:1:length(compressor.fluid.v.out.time)
    VolumetricEfficiency.values(t) = 1 + C -C*(compressor.fluid.v.in.signals.values(t)/compressor.fluid.v.out.signals.values(t));
end
compressor.VolumetricEfficiency = VolumetricEfficiency;

% Save results
save(append('Results/simlog_Tenv',string(T_init)),'Distance','ElectricEnergy', 'simlog', 'EPowers', 'chiller',...
    'chillerByPassValve', 'compressor', 'condenser', 'battery'); 




















% 
% Tenv = 32;
% 
% simlog_AMPC_Tenv35 = simlog_ElectricVehicleThermalManagement;
% chiller_AMPC_Tenv35.efficiency.effCoeff = Efficiency_chiller;
% %condenser_AMPC_Tenv35.efficiency.effCoeff = Efficiency_condenser;
% chiller_AMPC_Tenv35.TwoP.h.in = h_chiller_2P_in;
% chiller_AMPC_Tenv35.TwoP.h.out =  h_chiller_2P_out;
% chiller_AMPC_Tenv35.TL.h.in = h_chiller_TL_in;
% chiller_AMPC_Tenv35.TL.h.out = h_chiller_TL_out;
% compressor_AMPC_Tenv35.fluid.h.in = h_comp_in;
% compressor_AMPC_Tenv35.fluid.h.out = h_comp_out;
% condenser_AMPC_Tenv35.TwoP.h.in = h_cond_2P_in;
% condenser_AMPC_Tenv35.TwoP.h.out = h_cond_2P_out;
% battery_AMPC_Tenv35.Q_joule = Q_joule;
% battery_AMPC_Tenv35.T = BatteryTemperature;
% battery_AMPC_Tenv35.i.tot = i_battery;
% battery_AMPC_Tenv35.i.BMS = i_BMS;
% chiller_AMPC_Tenv35.TwoP.mdot = mdot_chiller_2P_out;
% chiller_AMPC_Tenv35.TL.mdot.in = mdot_chiller_TL_in;
% chiller_AMPC_Tenv35.TL.mdot.out = mdot_chiller_TL_out;
% chillerByPassValve_AMPC_Tenv35.mdot.in = mdot_ChillerByPassValve_in;
% chillerByPassValve_AMPC_Tenv35.mdot.outB = mdot_ChillerByPassValve_outB;
% chillerByPassValve_AMPC_Tenv35.mdot.outC = mdot_ChillerByPassValve_outC;
% compressor_AMPC_Tenv35.fluid.mdot.in = mdot_comp_in;
% compressor_AMPC_Tenv35.fluid.mdot.out = mdot_comp_out;
% condenser_AMPC_Tenv35.TwoP.mdot.out = mdot_cond_2P_out;
% condenser_AMPC_Tenv35.TwoP.mdot.in = mdot_cond_in;
% battery_AMPC_Tenv35.coolant.SC3.mdot = mdot_coolant_battery_in;
% battery_AMPC_Tenv35.coolant.SC4.mdot = mdot_coolant_battery_out;
% chiller_AMPC_Tenv35.TwoP.p.in = p_chiller_2P_in;
% chiller_AMPC_Tenv35.TwoP.p.out = p_chiller_2P_out;
% chiller_AMPC_Tenv35.TL.p.in = p_chiller_TL_in;
% chiller_AMPC_Tenv35.TL.p.out = p_chiller_TL_out;
% chillerByPassValve_AMPC_Tenv35.p.in = p_ChillerByPassValve_in;
% chillerByPassValve_AMPC_Tenv35.p.outB = p_ChillerByPassValve_outB;
% chillerByPassValve_AMPC_Tenv35.p.outC = p_ChillerByPassValve_outC;
% compressor_AMPC_Tenv35.fluid.p.in = p_comp_in;
% compressor_AMPC_Tenv35.fluid.p.out = p_comp_out;
% condenser_AMPC_Tenv35.TwoP.p.in = p_cond_2P_in;
% condenser_AMPC_Tenv35.TwoP.p.out = p_cond_2P_out;
% battery_AMPC_Tenv35.coolant.SC3.p = p_coolant_battery_in;
% battery_AMPC_Tenv35.coolant.SC4.p = p_coolant_battery_out;
% battery_AMPC_Tenv35.coolant.SC3.Phi = Phi_battery_in;
% battery_AMPC_Tenv35.coolant.SC4.Phi = Phi_battery_out;
% chiller_AMPC_Tenv35.TwoP.Phi.in = Phi_chiller_2P_in;
% chiller_AMPC_Tenv35.TwoP.Phi.out = Phi_chiller_out;
% chiller_AMPC_Tenv35.TL.Phi.in = Phi_chiller_TL_in;
% chiller_AMPC_Tenv35.TL.Phi.out = Phi_chiller_TL_out;
% chillerByPassValve_AMPC_Tenv35.Phi.in = Phi_ChillerByPassValve_in;
% chillerByPassValve_AMPC_Tenv35.Phi.outB = Phi_ChillerByPassValve_outB;
% chillerByPassValve_AMPC_Tenv35.Phi.outC = Phi_ChillerByPassValve_outC;
% compressor_AMPC_Tenv35.fluid.Phi.in = Phi_comp_in;
% compressor_AMPC_Tenv35.fluid.Phi.out = Phi_comp_out;
% condenser_AMPC_Tenv35.TwoP.Phi.in = Phi_cond_in;
% condenser_AMPC_Tenv35.TwoP.Phi.out = Phi_cond_out;
% chiller_AMPC_Tenv35.TL.rho.in = rho_chiller_TL_in;
% chiller_AMPC_Tenv35.TL.rho.out = rho_chiller_TL_out;
% chillerByPassValve_AMPC_Tenv35.rho.in = rho_ChillerByPassValve_in;
% chillerByPassValve_AMPC_Tenv35.rho.outB = rho_ChillerByPassValve_outB;
% chillerByPassValve_AMPC_Tenv35.rho.outC = rho_ChillerByPassValve_outC;
% battery_AMPC_Tenv35.coolant.SC3.rho = rho_coolant_battery_in;
% battery_AMPC_Tenv35.coolant.SC4.rho = rho_coolant_battery_out;
% chiller_AMPC_Tenv35.TwoP.T.in = T_chiller_2P_in;
% chiller_AMPC_Tenv35.TwoP.T.out = T_chiller_2P_out;
% chiller_AMPC_Tenv35.TL.T.in = T_chiller_TL_in;
% chiller_AMPC_Tenv35.TL.T.out = T_chiller_TL_out;
% chillerByPassValve_AMPC_Tenv35.T.in = T_ChillerByPassValve_in;
% chillerByPassValve_AMPC_Tenv35.T.outB = T_ChillerByPassValve_outB;
% chillerByPassValve_AMPC_Tenv35.T.outC = T_ChillerByPassValve_outC;
% compressor_AMPC_Tenv35.fluid.T.in = T_comp_in;
% compressor_AMPC_Tenv35.fluid.T.out = T_comp_out;
% condenser_AMPC_Tenv35.TwoP.T.in = T_cond_2P_in;
% condenser_AMPC_Tenv35.TwoP.T.out = T_cond_2P_out;
% battery_AMPC_Tenv35.coolant.SC3.T = T_coolant_battery_in;
% battery_AMPC_Tenv35.coolant.SC4.T = T_coolant_battery_out;
% chiller_AMPC_Tenv35.TwoP.u.in = u_chiller_2P_in;
% chiller_AMPC_Tenv35.TwoP.u.out = u_chiller_2P_out;
% chiller_AMPC_Tenv35.TL.u.in = u_chiller_TL_in;
% chiller_AMPC_Tenv35.TL.u.out = u_chiller_TL_out;
% chillerByPassValve_AMPC_Tenv35.u.in = u_ChillerByPassValve_in;
% chillerByPassValve_AMPC_Tenv35.u.outB = u_ChillerByPassValve_outB;
% chillerByPassValve_AMPC_Tenv35.u.outC = u_ChillerByPassValve_outC;
% compressor_AMPC_Tenv35.fluid.u.in = u_comp_in;
% compressor_AMPC_Tenv35.fluid.u.out = u_comp_out;
% condenser_AMPC_Tenv35.TwoP.u.in = u_cond_2P_in;
% condenser_AMPC_Tenv35.TwoP.u.out = u_cond_2P_out;
% battery_AMPC_Tenv35.coolant.SC3.u = u_coolant_battery_in;
% battery_AMPC_Tenv35.coolant.SC4.u = u_coolant_battery_out;
% chiller_AMPC_Tenv35.TwoP.v.in = v_chiller_2P_in;
% chiller_AMPC_Tenv35.TwoP.v.out = v_chiller_2P_out;
% compressor_AMPC_Tenv35.fluid.v.in = v_comp_in;
% compressor_AMPC_Tenv35.fluid.v.out = v_comp_out;
% condenser_AMPC_Tenv35.TwoP.v.in = v_cond_2P_in;
% condenser_AMPC_Tenv35.TwoP.v.out = v_cond_2P_out;
% compressor_AMPC_Tenv35.fluid.vL.in = vL_comp_in;
% compressor_AMPC_Tenv35.fluid.vL.out = vL_comp_out;
% compressor_AMPC_Tenv35.fluid.vV.in = vV_comp_in;
% compressor_AMPC_Tenv35.fluid.vV.out = vV_comp_out;
% chiller_AMPC_Tenv35.TwoP.x.in = x_chiller_2P_in;
% chiller_AMPC_Tenv35.TwoP.x.out = x_chiller_2P_out;
% compressor_AMPC_Tenv35.fluid.x.in = x_comp_in;
% compressor_AMPC_Tenv35.fluid.x.out = x_comp_out;
% condenser_AMPC_Tenv35.TwoP.x.out = x_cond_2P_out;
% condenser_AMPC_Tenv35.TwoP.x.in = x_cond_2P_in;
% battery_AMPC_Tenv35.T = BatteryTemperature;
% condenser_AMPC_Tenv35.efficiency.h_infinite = h_infiniteCond;
% chiller_AMPC_Tenv35.efficiency.h_infinite = h_infiniteChiller;
% EPowers_AMPC_Tenv35.Compressor = EPower_Compressor;
% EPowers_AMPC_Tenv35.Fan = EPower_Fan;
% EPowers_AMPC_Tenv35.MotorPump = EPower_MotorPump;
% EPowers_AMPC_Tenv35.BatteryPump = EPower_BatteryPump;
% battery_AMPC_Tenv35.V = Voltage_battery;
% ElectricEnergy.battery.BTM.tot = Energy_BTM;
% ElectricEnergy.battery.tot = Energy_battery;
% ElectricEnergy.battery.PowerTrain.values = Energy_battery.signals.values - Energy_BTM.signals.values;
% ElectricEnergy.battery.PowerTrain.time = Energy_battery.time;
% ElectricEnergy.battery.BTM.compressor = Energy_compressor;
% ElectricEnergy.battery.BTM.fan = Energy_fan;
% 
% 
% 
% eta_Vnominal = 0.9;
% gamma = 1.13;
% p_in_nom = 0.3; %MPa
% beta_nom = 4.6;
% vr_nominal = ((beta_nom*p_in_nom)/(p_in_nom))^(1/gamma);
% C = (1-eta_Vnominal)/(vr_nominal-1);
% VolumetricEfficiency.time = compressor_AMPC_Tenv35.fluid.v.out.time;
% VolumetricEfficiency.values = zeros(length(compressor_AMPC_Tenv35.fluid.v.out.time),1);
% for t = 1:1:length(compressor_AMPC_Tenv35.fluid.v.out.time)
%     VolumetricEfficiency.values(t) = 1 + C -C*(compressor_AMPC_Tenv35.fluid.v.in.signals.values(t)/compressor_AMPC_Tenv35.fluid.v.out.signals.values(t));
% end
% 
% compressor_AMPC_Tenv35.VolumetricEfficiency = VolumetricEfficiency;
% 
% if Tenv ==33
%     compressor_AMPC_Tenv33 = compressor_AMPC_Tenv35;
%     condenser_AMPC_Tenv33 = condenser_AMPC_Tenv35;
%     chiller_AMPC_Tenv33 = chiller_AMPC_Tenv35;
%     battery_AMPC_Tenv33 = battery_AMPC_Tenv35;
%     EPowers_AMPC_Tenv33 = EPowers_AMPC_Tenv35;
%     simlog_AMPC_Tenv33 = simlog_AMPC_Tenv35;
%     chillerByPassValve_AMPC_Tenv33 = chillerByPassValve_AMPC_Tenv35;
%     ElectricEnergy_AMPC_Tenv33 = ElectricEnergy;
%     Distance_AMPC_Tenv33 = distance_km;
% 
% 
%     save simlog_AMPC_Tenv33 Distance_AMPC_Tenv33 ElectricEnergy_AMPC_Tenv33 simlog_AMPC_Tenv33 EPowers_AMPC_Tenv33 chiller_AMPC_Tenv33 chillerByPassValve_AMPC_Tenv33 compressor_AMPC_Tenv33 condenser_AMPC_Tenv33 battery_AMPC_Tenv33 
% end
% 
% if Tenv ==20
%     compressor_AMPC_Tenv20 = compressor_AMPC_Tenv35;
%     condenser_AMPC_Tenv20 = condenser_AMPC_Tenv35;
%     chiller_AMPC_Tenv20 = chiller_AMPC_Tenv35;
%     battery_AMPC_Tenv20 = battery_AMPC_Tenv35;
%     EPowerBTM_AMPC_Tenv20 = EPowers_AMPC_Tenv35;
%     simlog_AMPC_Tenv20 = simlog_AMPC_Tenv35;
%     chillerByPassValve_AMPC_Tenv20 = chillerByPassValve_AMPC_Tenv35;
%     ElectricEnergy_AMPC_Tenv20 = ElectricEnergy;
%     Distance_AMPC_Tenv20 = distance_km;
% 
% 
%     save simlog_AMPC_Tenv20 Distance_AMPC_Tenv20 ElectricEnergy_AMPC_Tenv20 simlog_AMPC_Tenv20 EPowerBTM_AMPC_Tenv20 chiller_AMPC_Tenv20 chillerByPassValve_AMPC_Tenv20 compressor_AMPC_Tenv20 condenser_AMPC_Tenv20 battery_AMPC_Tenv20 
% end 
% 
% if Tenv == 25
%     compressor_AMPC_Tenv25 = compressor_AMPC_Tenv35;
%     condenser_AMPC_Tenv25 = condenser_AMPC_Tenv35;
%     chiller_AMPC_Tenv25 = chiller_AMPC_Tenv35;
%     battery_AMPC_Tenv25 = battery_AMPC_Tenv35;
%     EPowerBTM_AMPC_Tenv25 = EPowers_AMPC_Tenv35;
%     simlog_AMPC_Tenv25 = simlog_AMPC_Tenv35;
%     chillerByPassValve_AMPC_Tenv25 = chillerByPassValve_AMPC_Tenv35;
%     ElectricEnergy_AMPC_Tenv25 = ElectricEnergy;
%     Distance_AMPC_Tenv25 = distance_km;
% 
%     save simlog_AMPC_Tenv25 Distance_AMPC_Tenv25 ElectricEnergy_AMPC_Tenv25 simlog_AMPC_Tenv25 EPowerBTM_AMPC_Tenv25 chiller_AMPC_Tenv25 chillerByPassValve_AMPC_Tenv25 compressor_AMPC_Tenv25 condenser_AMPC_Tenv25 battery_AMPC_Tenv25 
% end 
% 
% if Tenv == 32 
%     compressor_AMPC_Tenv32 = compressor_AMPC_Tenv35;
%     condenser_AMPC_Tenv32 = condenser_AMPC_Tenv35;
%     chiller_AMPC_Tenv32 = chiller_AMPC_Tenv35;
%     battery_AMPC_Tenv32 = battery_AMPC_Tenv35;
%     EPowerBTM_AMPC_Tenv32 = EPowers_AMPC_Tenv35;
%     simlog_AMPC_Tenv32 = simlog_AMPC_Tenv35;
%     chillerByPassValve_AMPC_Tenv32 = chillerByPassValve_AMPC_Tenv35;
%     ElectricEnergy_AMPC_Tenv32 = ElectricEnergy;
%     Distance_AMPC_Tenv32 = distance_km;
% 
%     save simlog_AMPC_Tenv32 Distance_AMPC_Tenv32 ElectricEnergy_AMPC_Tenv32 simlog_AMPC_Tenv32 EPowerBTM_AMPC_Tenv32 chiller_AMPC_Tenv32 chillerByPassValve_AMPC_Tenv32 compressor_AMPC_Tenv32 condenser_AMPC_Tenv32 battery_AMPC_Tenv32 
% end 
% 
% if Tenv == 26
%     compressor_AMPC_Tenv26 = compressor_AMPC_Tenv35;
%     condenser_AMPC_Tenv26 = condenser_AMPC_Tenv35;
%     chiller_AMPC_Tenv26 = chiller_AMPC_Tenv35;
%     battery_AMPC_Tenv26 = battery_AMPC_Tenv35;
%     EPowerBTM_AMPC_Tenv26 = EPowers_AMPC_Tenv35;
%     simlog_AMPC_Tenv26 = simlog_AMPC_Tenv35;
%     chillerByPassValve_AMPC_Tenv26 = chillerByPassValve_AMPC_Tenv35;
%     ElectricEnergy_AMPC_Tenv26 = ElectricEnergy;
%     Distance_AMPC_Tenv26 = distance_km;
% 
%     save simlog_AMPC_Tenv26 Distance_AMPC_Tenv26 ElectricEnergy_AMPC_Tenv26 simlog_AMPC_Tenv26 EPowerBTM_AMPC_Tenv26 chiller_AMPC_Tenv26 chillerByPassValve_AMPC_Tenv26 compressor_AMPC_Tenv26 condenser_AMPC_Tenv26 battery_AMPC_Tenv26 
% end 
% 
% 


















